# AIO Outsourcing System - MVP (PHP + MySQL, Monolith)

This package contains a minimal, ready-to-deploy monolithic PHP application for an All-In-One Outsourcing MVP.
It includes basic authentication, employee management, and payroll generation. Designed for easy local deployment with Docker.

## Quickstart (Docker)

1. Unzip the project and `cd` into the folder.
2. The PHP app files are inside the `app/` folder. We provide a `docker-compose.yml` that runs:
   - PHP Apache (serving `app/`)
   - MySQL 8.0 (database)
   - phpMyAdmin for DB management (port 8081)
3. Start containers:
```bash
docker-compose up -d
```
4. Import the schema (optional):
- Open http://localhost:8081 and login with:
  - **Server:** mysql
  - **Username:** root
  - **Password:** rootpassword
- Run the SQL in `database/schema.sql` (it also includes a sample admin user and sample employees).

5. Open the app at http://localhost:8080
- Login credentials (seeded):
  - **username:** admin
  - **password:** password123

## File structure (important)
- `app/` - PHP application (entry: `index.php`)
- `database/schema.sql` - Database schema & seed
- `docker-compose.yml` - Quick deployment stack
- `README.md` - This file

## Notes & Next steps
- This is an MVP and NOT production hardened. For production:
  - Replace default passwords and secrets.
  - Use HTTPS and proper CORS settings.
  - Implement CSRF protection, input validation, and prepared statements (already used PDO prepared in code).
  - Move environment variables out of code and into a secure store.
- You can evolve this app into a more modular MVC structure or migrate to a framework (Laravel) later.

Enjoy!

-- AIO Outsourcing Dev Team
