<?php
// lib/auth.php - very small auth helper (for MVP only)
function is_logged_in() {
    return !empty($_SESSION['user']);
}

function login($username, $password) {
    $db = db();
    $stmt = $db->prepare('SELECT * FROM users WHERE username = ? LIMIT 1');
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    if ($user && password_verify($password, $user['password_hash'])) {
        // store minimal user info in session
        $_SESSION['user'] = ['id'=>$user['id'],'username'=>$user['username'],'role'=>$user['role']];
        return true;
    }
    return false;
}

function logout() {
    unset($_SESSION['user']);
}
?>