<?php
$db = db();
// handle create
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['create'])) {
    $name = $_POST['name'] ?? '';
    $position = $_POST['position'] ?? '';
    $salary = (float)($_POST['salary'] ?? 0);
    $stmt = $db->prepare('INSERT INTO employees (name, position, salary, status) VALUES (?, ?, ?, "active")');
    $stmt->execute([$name,$position,$salary]);
    header('Location: index.php?p=employees'); exit;
}
// handle delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $db->prepare('DELETE FROM employees WHERE id=?')->execute([$id]);
    header('Location: index.php?p=employees'); exit;
}
$rows = $db->query('SELECT * FROM employees ORDER BY id DESC')->fetchAll();
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Employees - <?=APP_NAME?></title></head>
<body>
<h1>Data Karyawan</h1>
<a href="index.php">Back</a>
<h2>Tambah Karyawan</h2>
<form method="post">
<label>Nama: <input name="name" required></label><br>
<label>Posisi: <input name="position" required></label><br>
<label>Gaji Pokok: <input name="salary" required></label><br>
<button name="create">Tambah</button>
</form>
<h2>Daftar</h2>
<table border="1" cellpadding="6" cellspacing="0">
<tr><th>ID</th><th>Nama</th><th>Posisi</th><th>Gaji</th><th>Status</th><th>Aksi</th></tr>
<?php foreach($rows as $r): ?>
<tr>
<td><?= $r['id'] ?></td>
<td><?= htmlspecialchars($r['name']) ?></td>
<td><?= htmlspecialchars($r['position']) ?></td>
<td><?= number_format($r['salary'],0,',','.') ?></td>
<td><?= htmlspecialchars($r['status']) ?></td>
<td><a href="index.php?p=employees&delete=<?= $r['id'] ?>" onclick="return confirm('Hapus?')">Hapus</a></td>
</tr>
<?php endforeach; ?>
</table>
</body>
</html>
