<?php
$db = db();
// generate payroll for month (simple)
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['generate'])) {
    $month = $_POST['month'] ?? date('Y-m');
    // for each active employee, create payroll record if not exists
    $emps = $db->query("SELECT id, salary FROM employees WHERE status='active'")->fetchAll();
    $stmt = $db->prepare("INSERT INTO payroll (employee_id, month, gross_salary, deductions, net_salary, status) VALUES (?, ?, ?, 0, ?, 'processed')");
    foreach($emps as $e) {
        $gross = $e['salary'];
        $net = $gross; // MVP: no deductions
        // avoid duplicates
        $exists = $db->prepare('SELECT COUNT(*) as c FROM payroll WHERE employee_id=? AND month=?');
        $exists->execute([$e['id'],$month]);
        if ($exists->fetch()['c']==0) {
            $stmt->execute([$e['id'],$month,$gross,$net]);
        }
    }
    header('Location: index.php?p=payroll'); exit;
}
// list payroll
$rows = $db->query('SELECT p.*, e.name FROM payroll p JOIN employees e ON e.id=p.employee_id ORDER BY p.id DESC')->fetchAll();
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Payroll - <?=APP_NAME?></title></head>
<body>
<h1>Payroll</h1>
<a href="index.php">Back</a>
<h2>Generate Payroll</h2>
<form method="post">
<label>Bulan (YYYY-MM): <input name="month" value="<?=date('Y-m')?>" required></label>
<button name="generate">Generate</button>
</form>
<h2>Daftar Payroll</h2>
<table border="1" cellpadding="6" cellspacing="0">
<tr><th>ID</th><th>Employee</th><th>Month</th><th>Gross</th><th>Net</th><th>Status</th></tr>
<?php foreach($rows as $r): ?>
<tr>
<td><?= $r['id'] ?></td>
<td><?= htmlspecialchars($r['name']) ?></td>
<td><?= htmlspecialchars($r['month']) ?></td>
<td><?= number_format($r['gross_salary'],0,',','.') ?></td>
<td><?= number_format($r['net_salary'],0,',','.') ?></td>
<td><?= htmlspecialchars($r['status']) ?></td>
</tr>
<?php endforeach; ?>
</table>
</body>
</html>
