-- schema.sql - MySQL schema for AIO Outsourcing MVP
CREATE DATABASE IF NOT EXISTS aio_outsourcing CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE aio_outsourcing;

CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(100) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('admin','hr','employee') NOT NULL DEFAULT 'employee',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE employees (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(200) NOT NULL,
  position VARCHAR(100),
  salary DECIMAL(12,2) DEFAULT 0,
  status ENUM('active','inactive') DEFAULT 'active',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE payroll (
  id INT AUTO_INCREMENT PRIMARY KEY,
  employee_id INT NOT NULL,
  month VARCHAR(7) NOT NULL,
  gross_salary DECIMAL(12,2) NOT NULL,
  deductions DECIMAL(12,2) DEFAULT 0,
  net_salary DECIMAL(12,2) NOT NULL,
  status VARCHAR(50) DEFAULT 'processed',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (employee_id) REFERENCES employees(id) ON DELETE CASCADE
);

-- seed user for login (username: admin, password: password123)
INSERT INTO users (username, password_hash, role) VALUES ('admin', '$2y$10$KbQi8vQkqvZ0sQJ5kYV1UuQjG6h0fZ0Xy2f6aZC1f8K7Lwq8G5t9e', 'admin');
-- The password hash above corresponds to 'password123' using password_hash in PHP (PASSWORD_BCRYPT)

INSERT INTO employees (name, position, salary) VALUES
('Andi Kurnia', 'Operator', 3000000),
('Budi Santoso', 'Supervisor', 5000000);
